<?php get_header(); ?>

<?php //start by fetching the terms for the animal_cat taxonomy
	$terms = get_terms( 'team_category', array(
		'orderby'    => 'count',
		'hide_empty' => 0,
		'exclude' => '27'
	) );
?>
	
	<div class="team-list">
		<div class="container">
			<div class="breadcrumbs-box wow fadeInRight">
				<p id="breadcrumbs"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>"><img src="<?php echo get_template_directory_uri(); ?>/includes/img/home.svg"></a> / <a href="/o-firmie">O firmie</a> / <a href="/zespol/">O nas</a></p>
			</div>
			
			<div class="text-center">
				<h2 class="page-title wow fadeInLeft" data-wow-delay="500ms"><span>Nasz zespół</span></h2>
			</div>
			
			<?php foreach( $terms as $term ) {
			 
				$args = array(
					'post_type' => 'team',
					'team_category' => $term->slug,
					'orderby' => 'menu_order',
					'order' => 'ASC'
				);
				$query = new WP_Query( $args ); ?>
						
				<?php $del = 200;
				if ($query->have_posts() ) { ?>
					<h4 class="wow fadeIn" data-wow-delay="<?php echo $del; ?>ms"><?php echo $term->name; ?></h4>
					<div class="row team-members">
						<?php while ($query->have_posts()) : $query->the_post(); ?>
							<div class="col-sm-6 marginbottom wow fadeIn" data-wow-delay="<?php echo $del; ?>ms">
								<?php if ( has_post_thumbnail() ) {
									$thumb_id = get_post_thumbnail_id(get_the_ID()); ?>
									<div class="team-thumbnail thumbnail-200 thumbnail-cover" style="background-image:url(<?php echo wp_get_attachment_url($thumb_id);?>);" data-type="background">
										<a href="<?php the_permalink() ?>" title="<?php the_title_attribute(); ?>" class="link-absolute hover-link link-bordered"><span></span></a>
									</div>
								<?php } ?>
								<p><strong><a href="<?php the_permalink() ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></strong></p>								
							</div>
						<?php $del = $del + 150;
						endwhile; ?>
					</div>
				<?php } 
				wp_reset_postdata();
			} ?>
			
		</div>
	</div>
	
<?php get_footer(); ?>